/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.autocrafting.engine.task.inputs;

import com.raoulvdberge.refinedstorage.api.autocrafting.engine.CraftingTaskReadException;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.engine.task.inputs.DurabilityInput;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.FluidStack;

public class Input {
    public static final String TYPE = "default";
    public static final String NBT_INPUT_TYPE = "InputType";
    private static final String NBT_ITEMSTACKS = "Itemstacks";
    private static final String NBT_FLUIDSTACK = "Fluidstack";
    private static final String NBT_CURRENT_INPUT_COUNTS = "CurrentInputCounts";
    private static final String NBT_TO_CRAFT_AMOUNT = "ToCraftAmount";
    private static final String NBT_AMOUNT_NEEDED = "AmountNeeded";
    private static final String NBT_PROCESSING_AMOUNT = "ProcessingAmount";
    private static final String NBT_QUANTITY_PER_CRAFT = "QuantityPerCraft";
    private final List<ItemStack> itemStacks = NonNullList.func_191196_a();
    private FluidStack fluidStack;
    protected long totalInputAmount;
    private final LongArrayList currentInputCounts = new LongArrayList(9);
    protected long toCraftAmount;
    protected long amountNeeded;
    protected long processingAmount = 0L;
    protected int quantityPerCraft;

    private Input(long amount) {
        this.amountNeeded = amount;
    }

    public Input(@Nonnull NonNullList<ItemStack> itemStacks, long amountNeeded) {
        this(amountNeeded);
        itemStacks.forEach(i -> this.itemStacks.add(i.func_77946_l()));
        this.quantityPerCraft = ((ItemStack)itemStacks.get(0)).func_190916_E();
        this.itemStacks.forEach(i -> this.currentInputCounts.add(0L));
    }

    public Input(@Nonnull FluidStack fluidStack, long amountNeeded) {
        this(amountNeeded);
        this.fluidStack = fluidStack.copy();
        this.quantityPerCraft = fluidStack.amount;
        this.currentInputCounts.add(0L);
    }

    public Input(@Nonnull NBTTagCompound compound) throws CraftingTaskReadException {
        int i;
        this.amountNeeded = compound.func_74763_f(NBT_AMOUNT_NEEDED);
        this.quantityPerCraft = compound.func_74762_e(NBT_QUANTITY_PER_CRAFT);
        this.toCraftAmount = compound.func_74763_f(NBT_TO_CRAFT_AMOUNT);
        this.processingAmount = compound.func_74763_f(NBT_PROCESSING_AMOUNT);
        if (compound.func_74764_b(NBT_ITEMSTACKS)) {
            NBTTagList itemStacks = compound.func_150295_c(NBT_ITEMSTACKS, 10);
            if (itemStacks.func_74745_c() < 1 && !(this instanceof DurabilityInput)) {
                throw new CraftingTaskReadException("Item stack list of input is empty. Expected at least 1!");
            }
            for (i = 0; i < itemStacks.func_74745_c(); ++i) {
                this.itemStacks.add(new ItemStack(itemStacks.func_150305_b(i)));
            }
        } else if (compound.func_74764_b(NBT_FLUIDSTACK)) {
            this.fluidStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)compound.func_74775_l(NBT_FLUIDSTACK));
        } else {
            throw new CraftingTaskReadException("Input does not have item or fluid stack key! " + compound);
        }
        NBTTagList inputCounts = compound.func_150295_c(NBT_CURRENT_INPUT_COUNTS, 4);
        for (i = 0; i < inputCounts.func_74745_c(); ++i) {
            this.currentInputCounts.add(((NBTTagLong)inputCounts.func_179238_g(i)).func_150291_c());
        }
        if (this.currentInputCounts.size() != (this.isFluid() ? 1 : this.itemStacks.size())) {
            throw new CraftingTaskReadException("Input count list length does not match item/fluid stack count! " + this.currentInputCounts.size() + " != " + (this.isFluid() ? 1 : this.itemStacks.size()) + " | isFluid: " + this.isFluid());
        }
        this.totalInputAmount = this.currentInputCounts.stream().mapToLong(l -> l).sum();
    }

    public long increaseItemStackAmount(@Nonnull ItemStack stack, long amount) {
        long needed = this.amountNeeded - this.totalInputAmount;
        long returns = this.totalInputAmount + amount - this.amountNeeded;
        this.totalInputAmount = returns < 0L ? this.totalInputAmount + amount : this.amountNeeded;
        for (int i = 0; i < this.itemStacks.size(); ++i) {
            if (!API.instance().getComparer().isEqualNoQuantity(stack, this.itemStacks.get(i))) continue;
            long currentCount = this.currentInputCounts.getLong(i);
            this.currentInputCounts.set(i, currentCount + (returns < 0L ? amount : needed));
            break;
        }
        return returns < 0L ? -1L : returns;
    }

    public long increaseFluidStackAmount(long amount) {
        long needed = this.amountNeeded - this.totalInputAmount;
        if (amount <= needed) {
            this.totalInputAmount += amount;
            this.currentInputCounts.set(0, this.totalInputAmount);
            return -1L;
        }
        long returns = this.totalInputAmount + amount - this.amountNeeded;
        this.totalInputAmount = this.amountNeeded;
        this.currentInputCounts.set(0, this.totalInputAmount);
        return returns;
    }

    public void increaseToCraftAmount(long amount) {
        this.toCraftAmount += amount;
    }

    public void decreaseToCraftAmount(@Nonnull ItemStack stack) {
        int i;
        boolean found = false;
        List<ItemStack> stacks = this.itemStacks;
        for (i = 0; i < stacks.size(); ++i) {
            ItemStack itemStack = stacks.get(i);
            if (!API.instance().getComparer().isEqualNoQuantity(stack, itemStack)) continue;
            found = true;
            break;
        }
        if (!found) {
            return;
        }
        int realAmount = (int)Math.min(this.toCraftAmount, (long)stack.func_190916_E());
        this.toCraftAmount = Math.max(this.toCraftAmount - (long)stack.func_190916_E(), 0L);
        this.totalInputAmount += (long)realAmount;
        this.currentInputCounts.set(i, this.currentInputCounts.get(i) + (long)realAmount);
        stack.func_190918_g(realAmount);
    }

    public void decreaseToCraftAmount(@Nonnull FluidStack stack) {
        if (!API.instance().getComparer().isEqual(stack, this.getFluidStack(), 2)) {
            return;
        }
        long realAmount = Math.min(this.toCraftAmount, (long)stack.amount);
        this.toCraftAmount = Math.max(this.toCraftAmount - (long)stack.amount, 0L);
        this.totalInputAmount += realAmount;
        this.currentInputCounts.set(0, this.currentInputCounts.get(0) + realAmount);
        stack.amount = (int)((long)stack.amount - realAmount);
    }

    public void decreaseInputAmount(long amount) {
        this.totalInputAmount -= amount;
        if (this.isFluid()) {
            Long currentInputCount = this.currentInputCounts.get(0);
            this.currentInputCounts.set(0, (currentInputCount = Long.valueOf(currentInputCount - amount)) < 0L ? 0L : currentInputCount);
        } else {
            LongArrayList inputCounts = this.currentInputCounts;
            for (int i = 0; i < inputCounts.size(); ++i) {
                Long currentInputCount = (Long)inputCounts.get(i);
                if (currentInputCount == 0L) continue;
                if (amount < 1L) break;
                if ((currentInputCount = Long.valueOf(currentInputCount - amount)) < 0L) {
                    amount = -currentInputCount.longValue();
                    currentInputCount = 0L;
                } else {
                    amount = 0L;
                }
                inputCounts.set(i, currentInputCount);
            }
        }
    }

    @Nonnull
    public NBTTagCompound writeToNbt(@Nonnull NBTTagCompound compound) {
        NBTTagList list;
        compound.func_74778_a(NBT_INPUT_TYPE, this.getType());
        compound.func_74772_a(NBT_AMOUNT_NEEDED, this.amountNeeded);
        compound.func_74768_a(NBT_QUANTITY_PER_CRAFT, this.quantityPerCraft);
        compound.func_74772_a(NBT_TO_CRAFT_AMOUNT, this.toCraftAmount);
        compound.func_74772_a(NBT_PROCESSING_AMOUNT, this.processingAmount);
        if (!this.isFluid()) {
            list = new NBTTagList();
            for (ItemStack itemStack : this.itemStacks) {
                list.func_74742_a((NBTBase)itemStack.func_77955_b(new NBTTagCompound()));
            }
            compound.func_74782_a(NBT_ITEMSTACKS, (NBTBase)list);
        } else {
            compound.func_74782_a(NBT_FLUIDSTACK, (NBTBase)this.fluidStack.writeToNBT(new NBTTagCompound()));
        }
        list = new NBTTagList();
        for (Long currentInputCount : this.currentInputCounts) {
            list.func_74742_a((NBTBase)new NBTTagLong(currentInputCount.longValue()));
        }
        compound.func_74782_a(NBT_CURRENT_INPUT_COUNTS, (NBTBase)list);
        return compound;
    }

    public void merge(Input input) {
        if (input.isFluid()) {
            if (!this.isFluid()) {
                this.fluidStack = input.getFluidStack();
            } else {
                this.fluidStack.amount += input.getFluidStack().amount;
            }
            this.quantityPerCraft = this.fluidStack.amount;
        } else {
            this.quantityPerCraft += input.getQuantityPerCraft();
        }
    }

    public void setAmountNeeded(long amountNeeded) {
        this.amountNeeded = amountNeeded;
    }

    public void setProcessingAmount(long processingAmount) {
        this.processingAmount = Math.max(processingAmount, 0L);
    }

    public boolean isFluid() {
        return this.fluidStack != null;
    }

    @Nonnull
    public ItemStack getCompareableItemStack() {
        if (this.isFluid()) {
            throw new UnsupportedOperationException("Comparable ItemStack does not exist for fluid inputs!");
        }
        return this.itemStacks.get(0);
    }

    @Nonnull
    public String getType() {
        return TYPE;
    }

    public long getAmountNeeded() {
        return this.amountNeeded;
    }

    public long getProcessingAmount() {
        return this.processingAmount;
    }

    public long getTotalInputAmount() {
        return this.totalInputAmount;
    }

    public long getToCraftAmount() {
        return this.toCraftAmount;
    }

    public long getAmountMissing() {
        return Math.max(this.amountNeeded - this.totalInputAmount - this.toCraftAmount, 0L);
    }

    public long getMinimumCraftableAmount() {
        long minCraftAmount = this.totalInputAmount / (long)this.quantityPerCraft;
        if (minCraftAmount > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return minCraftAmount;
    }

    public LongArrayList getCurrentInputCounts() {
        return this.currentInputCounts;
    }

    public FluidStack getFluidStack() {
        return this.fluidStack;
    }

    public List<ItemStack> getItemStacks() {
        return this.itemStacks;
    }

    public int getQuantityPerCraft() {
        return this.quantityPerCraft;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Input input = (Input)o;
        if (this.itemStacks.size() != input.getItemStacks().size() || this.fluidStack == null == (input.getFluidStack() != null)) {
            return false;
        }
        for (int i = 0; i < this.itemStacks.size(); ++i) {
            if (API.instance().getComparer().isEqualNoQuantity(this.itemStacks.get(i), input.getItemStacks().get(i))) continue;
            return false;
        }
        return this.fluidStack == null || API.instance().getComparer().isEqual(this.fluidStack, input.getFluidStack(), 2);
    }
}

